#ifndef _SRCSTATE_H_
#define _SRCSTATE_H_

#include "AudioStack/AudioSources/clAudioSource.h"

#ifndef _DO_NOT_USE_BOSCH_OSAL_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <map>
#include <algorithm>

#else
#include <map>
#endif

namespace AudioStack
{
namespace SourceStateMachine
{
//class clAudioSource;

class clSrcState {
public:
   clSrcState(const tChar* pacName, AudioSource::AudioStates::enAudioStates enStateID);
   virtual ~clSrcState();

   typedef enum
   {
      On,
      Pause,
      Off,
      SrcAvailabilityChg
   } enTrigger;

   typedef enum {
      ENTRYCONDITION_NONE = 0,
      ENTRYCONDITION_INITIAL,
   } EEntryCondition;

   AudioSource::AudioStates::enAudioStates enGetStateID(){return m_enStateID;};

    static void vSetState(AudioSource::clAudioSource* pclAudioSource, clSrcState* pclState, tU32 u32UserData, tU8 enEntryCondition);
    static void vSetState(AudioSource::clAudioSource* pclAudioSource, clSrcState* pclState, tU32 u32UserData);
public:
    //Configurable Transitions
   virtual tVoid vSetTransition(enTrigger trigger, clSrcState* targetState);
   //Handle configured Transitions
   virtual tVoid vHandleTrigger(enTrigger trigger, AudioSource::clAudioSource* pclAudioSource, tU32 u32UserData);

   // transitions
   virtual void vEnter(AudioSource::clAudioSource* pclAudioSource, tU32 u32UserData, tU8 enEntryCondition);

   //message transitions
   virtual tVoid vMsg_On                (AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_RequestConfirmed  (AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_OnDone            (AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_Off               (AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_OffDone           (AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_Pause             (AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_PauseDone         (AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_Init              (AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_InitDone          (AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_ServiceAvailable  (AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_ServiceUnavailable(AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_WaitFor           (AudioSource::clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_SrcAvailabilityChg(AudioSource::clAudioSource* src, tU32 u32UserData);


   // members
   const tChar *m_pacName;          // state name for debug
   AudioSource::AudioStates::enAudioStates m_enStateID;
   tU32 m_u32UserData;

protected:
   std::map<enTrigger, clSrcState* > m_transitionCollection;
   tBool m_bTrace;
};

}//namespace
}//namespace


#endif // _SRCSTATE_H_
